"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
electron_1.contextBridge.exposeInMainWorld('electronAPI', {
    openOAuthWindow: function (authUrl) {
        return electron_1.ipcRenderer.send('open-oauth-window', authUrl);
    },
    onOAuthResult: function (callback) {
        return electron_1.ipcRenderer.on('oauth-result', callback);
    },
    offOAuthResult: function (callback) {
        return electron_1.ipcRenderer.removeListener('oauth-result', callback);
    },
    // Force close the OAuth window (if still open)
    closeOAuthWindow: function (dataString) {
        return electron_1.ipcRenderer.send('close-oauth-window', dataString);
    },
    // Click-Through Handling
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    turnClickThroughOff: function (callback) {
        return electron_1.ipcRenderer.send('set-ignore-mouse-events', false);
    },
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    turnClickThroughOn: function (callback) {
        return electron_1.ipcRenderer.send('set-ignore-mouse-events', true, { forward: true });
    },
    getAppVersion: function () { return electron_1.ipcRenderer.invoke('get-app-version'); },
    // System Info
    getSystemInfo: function () { return electron_1.ipcRenderer.invoke('get-system-info'); },
    // Extension Handling
    getExtensionPref: function () { return electron_1.ipcRenderer.invoke('get-extension-pref'); },
    setExtensionPref: function (enabled) {
        return electron_1.ipcRenderer.invoke('set-extension-pref', enabled);
    },
    // Let the web app know that the Electron Launched URL
    onCustomUrlOpened: function (callback) {
        electron_1.ipcRenderer.on('custom-url-opened', function (event, url) {
            callback(url);
        });
    },
    // Windows Handling
    onToggleFullScreen: function (callback) {
        return electron_1.ipcRenderer.send('toggle-fullscreen-window', callback);
    },
    onToggleMaximiseWindow: function (callback) {
        return electron_1.ipcRenderer.send('toggle-maximize-window', callback);
    },
    onToggleUnMaximiseWindow: function (callback) {
        return electron_1.ipcRenderer.send('toggle-unmaximize-window', callback);
    },
    onToggleMinimizeWindow: function (callback) {
        return electron_1.ipcRenderer.send('toggle-minimize-window', callback);
    },
    onWindowClose: function (callback) { return electron_1.ipcRenderer.send('close-window', callback); },
    onToggleAlwaysOnTop: function (flag) { return electron_1.ipcRenderer.send('toggleAlwaysOnTop', flag); },
    onOpenDevTools: function () { return electron_1.ipcRenderer.send('openDevTools'); },
    // Setting up a listener for the renderlog event
    onRenderlog: function (callback) { return electron_1.ipcRenderer.on('renderlog', callback); },
    // Bluetooth Handling
    onCancelScan: function (callback) { return electron_1.ipcRenderer.send('cancelScan', callback); },
    onDeviceListUpdated: function (callback) {
        return electron_1.ipcRenderer.on('deviceListUpdated', callback);
    },
    onDeviceSelected: function (deviceId) { return electron_1.ipcRenderer.send('deviceSelected', deviceId); },
    // Secure Storage (for Remember Me functionality)
    setSecureStorage: function (key, value) {
        return electron_1.ipcRenderer.invoke('secure-storage-set', key, value);
    },
    getSecureStorage: function (key) {
        return electron_1.ipcRenderer.invoke('secure-storage-get', key);
    },
    deleteSecureStorage: function (key) {
        return electron_1.ipcRenderer.invoke('secure-storage-delete', key);
    },
});
