class PageBackEventHandler extends SDEventHandler {

  handleStreamDeckEvent = (message) => {
    if (message.event === "pageback") {
      this._pagebackCall();
    }
  }

  _pagebackCall = () => {
    const button = document.querySelector('[jscontroller="pageBackButton"]');
    if (!button) {
      throw new ControlsNotFoundError("No Page Back button found!")
    }
    button.click();
  }

}
