// based on the pin_presentation_event_handler.js
class SortByDateJoinedEventHandler extends ToggleEventHandler {

  _controlElementSelector = () => {
    return document.querySelector(`[jscontroller="sortby_datejoined"]`);
  }

  _isElementMuted = (element) => {
    // "muted" means the button is NOT pressed.
    if (!element || element.attributes["aria-pressed"] === undefined) {
      /**
       * Note: It seems the "aria-pressed" attribute is usually missing until the
       * first time you try to pin the presentation.
       */
      return true;
    }
    return element.attributes["aria-pressed"]?.value === "false";
  }

  _getControlElement = () => {
    return this._controlElementSelector();
  };

  _sendMuteState = () => {
    this._sendSimpleMuteStateUpdate("sortByDateJoinedMutedState");
  }

  handleStreamDeckEvent = (message) => {
    if (message.event === "toggleSortByDateJoined") {
      this._toggleMute();
    } else if (message.event === "getSortByDateJoinedState") {
      this._sendMuteState();
    }
  }

  _registerMutationObserver = () => {
    const observer = new MutationObserver(this._handleControlChange);
    observer.observe(document.body, {
      childList: false,
      attributes: true,
      attributeFilter: ["aria-pressed"],
      attributeOldValue: true,
      subtree: true,
    });
  }

}